function [y,jac] = gauss1dfunct(p, x)

  % For this function, we need to input the four parameters in p [p(1),
  % p(2), p(3), and p(4)], and the x range in data. The parameters refer to
  % the constant term, amplitude term, stdev term and center term
  % respectively.
  % The output will be y and the jacobian
  
  a=p(1); b=p(2); c=p(3); d=p(4);
  
  U0=(x-d)/c;
  U=U0.*U0;
  U2=b*U0/c;
  U3=b/c*U0.*U0;
  expU=exp(-U/2);
  
  % y = p(1) + p(2) * exp(-(x-p(4))^2/(2*p(3)))
  
  y=a+b*expU;
  
  % The Jacobian of Gauss1d
  
  if nargout>1      % Jacobian required
      jac=zeros(length(x),4);
      jac(:,1)=1;
      jac(:,2)=expU;
      jac(:,3)=U3.*expU;
      jac(:,4)=U2.*expU;
  end
%     J = zeros(length(x),4);
%     J(:,1) = 1;
%     J(:,2) = exp(-(d - x).^2/(2*c^2));
%     J(:,3) = (b*exp(-(d - x).^2/(2*c^2)).*(d - x).^2)/c^3;
%     J(:,4) = -(b*exp(-(d - x).^2/(2*c^2)).*(2*d - 2*x))/(2*c^2);
  
end